/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theanomaly.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.mcreator.theanomaly.network.TheAnomalyModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GraphicsWeatherProcedure {
    private static Pattern pattern = Pattern.compile(".*\\.procedures\\..*Procedure\\$CustomDimensionEffects");
    private static List<Consumer<Object[]>> customWeather = null;
    private static Class<?> effects = null;
    private static float partialTick = 0.0f;
    private static int ticks = 0;

    public static void renderRain(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        double camX = pos.m_7096_();
        double camY = pos.m_7098_();
        double camZ = pos.m_7094_();
        int iCamX = Mth.m_14107_((double)camX);
        int iCamY = Mth.m_14107_((double)camY);
        int iCamZ = Mth.m_14107_((double)camZ);
        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.m_91405_() ? 10 : 5;
        int btm = iCamY - length;
        int top = iCamY + length;
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.m_46722_(partialTick);
        }
        if (top > height) {
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.m_14116_((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            RandomSource randomSource = RandomSource.m_216335_((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int counts = ticks + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
            float anime = -(((float)counts + partialTick) * speed) / 32.0f * (3.0f + randomSource.m_188501_());
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)top - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f, (float)btm * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)btm - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f, (float)top * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)btm - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f, (float)top * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)top - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f, (float)btm * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }

    public static void renderSnow(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        double camX = pos.m_7096_();
        double camY = pos.m_7098_();
        double camZ = pos.m_7094_();
        int iCamX = Mth.m_14107_((double)camX);
        int iCamY = Mth.m_14107_((double)camY);
        int iCamZ = Mth.m_14107_((double)camZ);
        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.m_91405_() ? 10 : 5;
        int btm = iCamY - length;
        int top = iCamY + length;
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.m_46722_(partialTick);
        }
        if (top > height) {
            RandomSource randomSource = RandomSource.m_216335_((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.m_14116_((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            float anime = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
            float time = (float)ticks + partialTick;
            float du = (float)(randomSource.m_188500_() + randomSource.m_188583_() * (double)time * 0.01) * speed;
            float dv = (float)(randomSource.m_188500_() + randomSource.m_188583_() * (double)time * 0.001) * (speed / 10.0f);
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            int sky = ((packedLight & 0xFFFF) * 3 + 240) / 4;
            int block = ((packedLight >> 16 & 0xFFFF) * 3 + 240) / 4;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)top - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f + du, (float)btm * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)btm - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f + du, (float)top * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)btm - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f + du, (float)top * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)top - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f + du, (float)btm * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }

    public static void renderWeather(boolean rain, boolean snow, float speed, int range, int color, boolean constant) {
        if (range > 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
            int ix = Mth.m_14107_((double)pos.m_7096_());
            int iy = Mth.m_14107_((double)pos.m_7098_());
            int iz = Mth.m_14107_((double)pos.m_7094_());
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    BlockPos blockPos = new BlockPos(ix + i, iy, iz + j);
                    Biome.Precipitation precipitation = ((Biome)level.m_204166_(blockPos).m_203334_()).m_47530_();
                    if (precipitation == Biome.Precipitation.NONE) continue;
                    if (rain && precipitation == Biome.Precipitation.RAIN) {
                        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/rain.png"));
                        GraphicsWeatherProcedure.renderRain(speed, ix + i, iz + j, range, color, constant);
                    }
                    if (!snow || precipitation != Biome.Precipitation.SNOW) continue;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/snow.png"));
                    GraphicsWeatherProcedure.renderSnow(speed, ix + i, iz + j, range, color, constant);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderWeather(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        try {
            Class<?> effects = Minecraft.m_91087_().f_91073_.m_104583_().getClass().getSuperclass();
            if (!pattern.matcher(effects.getName()).find()) {
                return;
            }
            if (effects != GraphicsWeatherProcedure.effects) {
                GraphicsWeatherProcedure.effects = effects;
                customWeather = (List)effects.getField("customWeather").get(null);
            }
            customWeather.add(new Consumer<Object[]>(){

                @Override
                public void accept(Object[] params) {
                    ticks = (Integer)params[1];
                    partialTick = ((Float)params[2]).floatValue();
                    Minecraft minecraft = Minecraft.m_91087_();
                    ClientLevel level = minecraft.f_91073_;
                    Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
                    if (entity != null) {
                        Vec3 pos = entity.m_20318_(partialTick);
                        LightTexture lightTexture = (LightTexture)params[3];
                        lightTexture.m_109896_();
                        RenderSystem.m_69493_();
                        RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
                        RenderSystem.m_69482_();
                        RenderSystem.m_69464_();
                        RenderSystem.m_69478_();
                        RenderSystem.m_69453_();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GraphicsWeatherProcedure.execute(null, (LevelAccessor)level);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.m_69461_();
                        RenderSystem.m_69481_();
                        RenderSystem.m_69482_();
                        RenderSystem.m_69458_((boolean)true);
                        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        lightTexture.m_109891_();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world) {
        GraphicsWeatherProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        if (TheAnomalyModVariables.MapVariables.get((LevelAccessor)world).customweather) {
            GraphicsWeatherProcedure.renderWeather(true, true, 1.0f, 5, -1, false);
        }
    }
}

